/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.readers;

import eu.europa.ec.taxud.cesop.readers.XmlStreamReaderWrapper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationSchema;

public class CesopXmlReader
implements AutoCloseable {
    private final XmlStreamReaderWrapper xmlStreamReaderWrapper;
    private final Map<String, String> values = new HashMap<String, String>();

    public CesopXmlReader(InputStream inputStream) throws XMLStreamException {
        this(inputStream, null);
    }

    public CesopXmlReader(InputStream inputStream, XMLValidationSchema xsd) throws XMLStreamException {
        this.xmlStreamReaderWrapper = new XmlStreamReaderWrapper(inputStream, xsd);
    }

    public QName getStartElementName() throws XMLStreamException {
        return this.xmlStreamReaderWrapper.getStartElementName();
    }

    public boolean positionCursorOnStartElement() throws XMLStreamException {
        boolean result = this.xmlStreamReaderWrapper.goToNextStartElement();
        this.xmlStreamReaderWrapper.markAsPeek();
        return result;
    }

    public boolean positionCursorOnStartElement(QName qName) throws XMLStreamException {
        boolean result = this.xmlStreamReaderWrapper.goToNextStartElement(qName);
        this.xmlStreamReaderWrapper.markAsPeek();
        return result;
    }

    public Optional<Map<String, String>> readNextTagIfEquals(QName qName) throws XMLStreamException {
        this.values.clear();
        if (this.positionCursorOnStartElement() && this.xmlStreamReaderWrapper.getStartElementName().equals(qName)) {
            this.readTagElements(qName, "/" + qName.getLocalPart());
            return Optional.of(this.values);
        }
        return Optional.empty();
    }

    public Map<String, String> readNextTagIntoMap(QName qName) throws XMLStreamException {
        this.values.clear();
        if (this.positionCursorOnStartElement(qName)) {
            this.readTagElements(qName, "/" + qName.getLocalPart());
            return this.values;
        }
        throw new XMLStreamException("Start tag not found: " + qName);
    }

    private void readTagElements(QName qName, String entryKey) throws XMLStreamException {
        while (this.xmlStreamReaderWrapper.hasNext()) {
            String data;
            this.xmlStreamReaderWrapper.moveToNextElement();
            if (this.xmlStreamReaderWrapper.isEndElement() && this.xmlStreamReaderWrapper.getEndElementName().equals(qName)) {
                return;
            }
            if (this.xmlStreamReaderWrapper.isStartElement()) {
                QName elementName = this.xmlStreamReaderWrapper.getStartElementName();
                String key = entryKey + "/" + elementName.getLocalPart();
                if (!elementName.equals(qName)) {
                    this.readAttributes(key);
                    this.readTagElements(elementName, key);
                    continue;
                }
                this.readAttributes(entryKey);
                continue;
            }
            if (!this.xmlStreamReaderWrapper.isCharactersElement() || (data = this.xmlStreamReaderWrapper.getCharacters().trim()).length() <= 0) continue;
            this.values.put(entryKey, data);
        }
        throw new XMLStreamException("End tag not found: " + qName);
    }

    private void readAttributes(String tagName) throws XMLStreamException {
        this.xmlStreamReaderWrapper.getAttributes().forEach((key, value) -> this.values.put(tagName + "@" + key, (String)value));
    }

    public XmlStreamReaderWrapper getXmlStreamReaderWrapper() {
        return this.xmlStreamReaderWrapper;
    }

    @Override
    public void close() throws XMLStreamException {
        this.xmlStreamReaderWrapper.close();
    }
}

